/*
V1.6
Este script se puede ejecutar antes de la reconversin
Crea todo lo necesario para luego poder configurar
el resto del sistema.
*/


DECLARE @FchIniA varchar(08)
DECLARE @FchIniPerA varchar(08)
DECLARE @MonAnt mon
DECLARE @MonNue mon
DECLARE @NomMonNue varchar(30)
DECLARE @SmbMon varchar(5)
DECLARE @TipTsa varchar(30)
DECLARE @FctrCamb Money 

SET @FchIniA='20211001'
SET @FchIniPerA='20211001'
SET @MonAnt='VES'
SET @MonNue='VED'
SET @NomMonNue ='Bolvar digital'
SET @SmbMon='Bs.' --la gaceta dice que se sigue usando este smbolo.
SET @TipTsa='BCCT'
SET @FctrCamb=1000000


--Crear nueva moneda a partir de la anterior
INSERT INTO GE_Mon
(Mon, CfdMon, CnpLspqCc, CnpLspqCp, CnsMdf, CodNcrcLspq, CodNcrpLspq, CodNdbcLspq, CodNdbpLspq, LCfdTsa, LCiaAut, LDenMon, NomMon, RdnCmp, RdnCstu, RdnVta, SmbMon, StmMdf, TolAjsCjaFtn, TolAjsCjaSbn, TolLspqNcrc, TolLspqNcrp, TolLspqNdbc, TolLspqNdbp, TolMnt, UsrMdf)
SELECT @MonNue Mon, 2, CnpLspqCc, CnpLspqCp, CnsMdf, CodNcrcLspq, CodNcrpLspq, 
	CodNdbcLspq, CodNdbpLspq, LCfdTsa, LCiaAut, '1|5|10|20|50|100' LDenMon, @NomMonNue, RdnCmp, RdnCstu, 
	RdnVta, @SmbMon, StmMdf, TolAjsCjaFtn, TolAjsCjaSbn, TolLspqNcrc, TolLspqNcrp, 
	TolLspqNdbc, TolLspqNdbp, TolMnt, UsrMdf
FROM GE_Mon Mon
WHERE Mon=@MonAnt
	AND Not EXISTS(
		SELECT *
		FROM GE_Mon Mon2
		WHERE Mon2.Mon=@MonNue)

--si la moneda 2 es la mon ant, y la tasa es directa, habra que dividir por 1.000.000
INSERT INTO GE_Tsa
(TipTsa, Mon1, Mon2, FchVig, cnsmdf, EsTsaDrct, StmMdf, Tsa, UsrMdf)
SELECT TipTsa, Mon1, Mon2, FchVig, CnsMdf, EsTsaDrct, StmMdf,Tsa, UsrMdf
FROM (

	SELECT TipTsa, 
	CASE WHEN Mon1<@MonNue THEN Mon1 ELSE @MonNue END Mon1, 
	CASE WHEN Mon1<@MonNue THEN @MonNue ELSE Mon1 END Mon2, 
	FchVig, 0 cnsmdf, 
	CASE WHEN Mon1<@MonNue THEN Tsa.EsTsaDrct ELSE CASE WHEN Tsa.EsTsaDrct=1 THEN 0 ELSE 1 END END EsTsaDrct, 
	@FchIniA StmMdf, ROUND(Tsa/@FctrCamb,4) Tsa, 'ADM' UsrMdf
	FROM GE_Tsa Tsa
	WHERE Mon2=@MonAnt
		AND EsTsaDrct=1
		AND Mon1<>@MonNue
		AND ROUND(Tsa/@FctrCamb,4)>0
	) TsaNue

	WHERE NOT EXISTS( 
		SELECT * 
		FROM GE_Tsa Tsa2
		WHERE Tsa2.TipTsa=TsaNue.TipTsa
			AND Tsa2.Mon1=TsaNue.Mon1
			AND Tsa2.Mon2=TsaNue.Mon2
			AND Tsa2.FchVig=TsaNue.FchVig)

--si la moneda 2 es la mon ant, y la tasa no es directa, habra que multiplicar por @FctrCamb
INSERT INTO GE_Tsa
(TipTsa, Mon1, Mon2, FchVig, cnsmdf, EsTsaDrct, StmMdf, Tsa, UsrMdf)
SELECT TipTsa, Mon1, Mon2, FchVig, CnsMdf, EsTsaDrct, StmMdf, Tsa, UsrMdf
FROM (

	SELECT TipTsa, 
	CASE WHEN Mon1<@MonNue THEN Mon1 ELSE @MonNue END Mon1, 
	CASE WHEN Mon1<@MonNue THEN @MonNue ELSE Mon1 END Mon2, 
	FchVig, 0 cnsmdf,
	CASE WHEN Mon1<@MonNue THEN Tsa.EsTsaDrct ELSE CASE WHEN Tsa.EsTsaDrct=1 THEN 0 ELSE 1 END END EsTsaDrct, 
	@FchIniA StmMdf, ROUND(Tsa*@FctrCamb,4) Tsa, 'ADM' UsrMdf
	FROM GE_Tsa Tsa
	WHERE Mon2=@MonAnt
		AND EsTsaDrct=0
		AND Mon1<>@MonNue
	) TsaNue

	WHERE NOT EXISTS( 
		SELECT * 
		FROM GE_Tsa Tsa2
		WHERE Tsa2.TipTsa=TsaNue.TipTsa
			AND Tsa2.Mon1=TsaNue.Mon1
			AND Tsa2.Mon2=TsaNue.Mon2
			AND Tsa2.FchVig=TsaNue.FchVig)


--si la moneda 1 es la mon ant, y la tasa es directa, habra que multiplicar por @FctrCamb
INSERT INTO GE_Tsa
(TipTsa, Mon1, Mon2, FchVig, cnsmdf, EsTsaDrct, StmMdf, Tsa, UsrMdf)

SELECT TipTsa, Mon1, Mon2, FchVig, CnsMdf, EsTsaDrct, StmMdf, Tsa, UsrMdf
FROM (

	SELECT TipTsa, 
	CASE WHEN Mon2<@MonNue THEN @MonNue ELSE Mon2 END Mon1, 
	CASE WHEN Mon2<@MonNue THEN Mon2 ELSE @MonNue END Mon2, 
	FchVig, 0 cnsmdf,
	CASE WHEN @MonNue<Mon2 THEN Tsa.EsTsaDrct ELSE CASE WHEN Tsa.EsTsaDrct=1 THEN 0 ELSE 1 END END EsTsaDrct, 
	@FchIniA StmMdf, ROUND(Tsa*@FctrCamb,4) Tsa, 'ADM' UsrMdf
	FROM GE_Tsa Tsa
	WHERE Mon1=@MonAnt
		AND EsTsaDrct=1
		AND Mon2<>@MonNue
	) TsaNue

	WHERE NOT EXISTS( 
		SELECT * 
		FROM GE_Tsa Tsa2
		WHERE Tsa2.TipTsa=TsaNue.TipTsa
			AND Tsa2.Mon1=TsaNue.Mon1
			AND Tsa2.Mon2=TsaNue.Mon2
			AND Tsa2.FchVig=TsaNue.FchVig)


--si la moneda 1 es la mon ant, y la tasa no es directa, habra que dividir por @FctrCamb
INSERT INTO GE_Tsa
(TipTsa, Mon1, Mon2, FchVig, cnsmdf, EsTsaDrct, StmMdf, Tsa, UsrMdf)


SELECT TipTsa, Mon1, Mon2, FchVig, CnsMdf, EsTsaDrct, StmMdf, Tsa, UsrMdf
FROM (

	SELECT TipTsa, 
	CASE WHEN Mon2<@MonNue THEN @MonNue ELSE Mon2 END Mon1, 
	CASE WHEN Mon2<@MonNue THEN Mon2 ELSE @MonNue END Mon2, 
	FchVig, 0 cnsmdf,
	CASE WHEN @MonNue<Mon2 THEN Tsa.EsTsaDrct ELSE CASE WHEN Tsa.EsTsaDrct=1 THEN 0 ELSE 1 END END EsTsaDrct, 
	@FchIniA StmMdf, ROUND(Tsa/@FctrCamb,4) Tsa, 'ADM' UsrMdf
	FROM GE_Tsa Tsa
	WHERE Mon1=@MonAnt
		AND EsTsaDrct=1
		AND Mon2<>@MonNue
		AND ROUND(Tsa/@FctrCamb,4)>0
	) TsaNue

	WHERE NOT EXISTS( 
		SELECT * 
		FROM GE_Tsa Tsa2
		WHERE Tsa2.TipTsa=TsaNue.TipTsa
			AND Tsa2.Mon1=TsaNue.Mon1
			AND Tsa2.Mon2=TsaNue.Mon2
			AND Tsa2.FchVig=TsaNue.FchVig)




--Agregar tasa de conversin desde el principio de los tiempos

-- *** ESTO PUEDE DAR ERROR SI LA TASA YA EXISTE, IGNORAR ***
IF NOT EXISTS(
	SELECT *
	FROM GE_Tsa
	WHERE TipTsa=@TipTsa
		AND Mon1=@MonAnt
		AND Mon2=@MonNue)
INSERT INTO GE_Tsa
(TipTsa, Mon1, Mon2, FchVig, EsTsaDrct, Tsa, CnsMdf, StmMdf, UsrMdf)
SELECT @TipTsa, 
CASE WHEN @MonAnt<@MonNue THEN @MonAnt ELSE @MonNue END, 
CASE WHEN @MonAnt<@MonNue THEN @MonNue ELSE @MonAnt END, 
'1999-01-01 00:00:00.000', 
CASE WHEN @MonAnt<@MonNue THEN 0 ELSE 1 END EsTsaDrct,
@FctrCamb, 0, GETDATE(),'ADM'

--Agregar vigencias de cuenta
INSERT INTO GE_CtabVig
(Ctab, PerVig, CnsMdf, DscVig, EsTsaDrctVig, MonVig, SldIBcoVig, SldICiaVig, StmMdf, TsaVig, UsrMdf)
SELECT CV.Ctab, @FchIniPerA PerVig, CnsMdf, 'Reconversin 2021 ' + @MonNue DscVig, 
EsTsaDrctVig, @MonNue, 0 SldIBcoVig, 0 SldICiaVig, StmMdf, @FctrCamb TsaVig, 'ADM'
FROM GE_CtabVig CV
Inner Join (
	select Ctab, Max(PerVig) PvM
	FROM GE_CtabVig CV
	WHERE MonVig=@MonAnt
	group by Ctab) V
ON V.Ctab=CV.Ctab
AND V.PvM=CV.PerVig
WHERE NOT EXISTS (
		SELECT * 
		FROM GE_CtabVig CVE
		WHERE CVE.Ctab=CV.Ctab
			AND CVE.PerVig=@FchIniPerA)


--Vigencia de impuestos
INSERT INTO GE_VigImt
(Cia, Imt, MonImt, FchVig, CnsMdf, DscVigImt, LImtIcl, StmMdf, UsrMdf)
SELECT VI.Cia, VI.Imt, @MonNue MonImt, VI.FchVig, VI.CnsMdf, 'Reconversin 2021 ' + @MonNue DscVigImt, VI.LImtIcl, VI.StmMdf, VI.UsrMdf
FROM GE_VigImt VI
INNER JOIN (
		SELECT Cia, Imt, MonImt, Max(FchVig) FchMax
		FROM GE_VigImt 
		WHERE MonImt=@MonAnt
		GROUP BY Cia, Imt, MonImt) VM
	ON VI.Cia=VM.Cia 
	AND VI.Imt=VM.Imt
	AND VI.MonImt=VM.MonImt
	AND VI.FchVig=VM.FchMax
WHERE VI.MonImt=@MonAnt


--Zitf VigImt
INSERT INTO GE_ZItf
(NomTbl, PkReg, NomCol, VlrACol)
SELECT NomTbl, ZK.PkRegNue, NomCol, VlrACol
FROM GE_ZItf ZVI
INNER JOIN (
		SELECT Cia+'|'+Imt+'|'+MonImt+'|'+ SUBSTRING(REPLACE(CONVERT(varchar(20), FchMax, 120),'-','/'),1,10) PkReg,
			Cia+'|'+Imt+'|'+@MonNue+'|'+ SUBSTRING(REPLACE(CONVERT(varchar(20), FchMax, 120),'-','/'),1,10) PkRegNue
		FROM (
			SELECT Cia, Imt, MonImt, Max(FchVig) FchMax
			FROM GE_VigImt 
			WHERE MonImt=@MonAnt
			GROUP BY Cia, Imt, MonImt) VM
		) ZK
	ON ZK.PkReg=ZVI.PkReg
WHERE NomTbl='GE_VigImt'

--GE_CalImt
INSERT INTO GE_CalImt
(Cia, Imt, MonImt, FchVig, Sec, AlcImvDet, AlcImvSjt, ClsDet, ClsSjt, LPmtCfc, MtdImt)
SELECT Cia, Imt, @MonNue MonImt, FchVig, Sec, AlcImvDet, AlcImvSjt, ClsDet, ClsSjt, LPmtCfc, MtdImt
FROM GE_CalImt
WHERE MonImt=@MonAnt

INSERT INTO GE_VigImtZ
(Cia, Imt, MonImt, FchVig, TratImt, XmlIfoImt)
SELECT Cia, Imt, @MonNue MonImt, FchVig, TratImt, XmlIfoImt
FROM GE_VigImtZ
WHERE MonImt=@MonAnt

-- Vigencia de retencin de impuestos
INSERT INTO GE_VigRimt
(Cia, Imt, MonImt, FchVig, CnpRimt, CnsMdf, CodNcrRimt, CodNdbRimt, DscVigRimt, LSpfCfc, StmMdf, UsrMdf)
SELECT Cia, Imt, @MonNue MonImt, FchVig, CnpRimt, CnsMdf, CodNcrRimt, CodNdbRimt, 'Reconversin 2021 ' + @MonNue, LSpfCfc, StmMdf, UsrMdf
FROM GE_VigRimt
WHERE MonImt=@MonAnt

INSERT INTO GE_ZItf
(NomTbl, PkReg, NomCol, VlrACol)

SELECT NomTbl, ZK.PkRegNue, NomCol, VlrACol
FROM GE_ZItf ZVR
INNER JOIN (
		SELECT Cia+'|'+Imt+'|'+MonImt+'|'+ SUBSTRING(REPLACE(CONVERT(varchar(20), FchVig, 120),'-','/'),1,10) PkReg,
			Cia+'|'+Imt+'|'+@MonNue+'|'+ SUBSTRING(REPLACE(CONVERT(varchar(20), FchVig, 120),'-','/'),1,10) PkRegNue
		FROM GE_VigRimt 
		WHERE MonImt=@MonAnt
		) ZK
	ON ZK.PkReg=ZVR.PkReg
WHERE ZVR.NomTbl='GE_VigRimt' 
	
	
--GE_CalRimt
INSERT INTO GE_CalRimt
(Cia, Imt, MonImt, FchVig, Sec, DscCal, FrmlCal, FrmlCnd, NpoCal, NpoCnd)
SELECT Cia, Imt, @MonNue MonImt, FchVig, Sec, DscCal, FrmlCal, FrmlCnd, NpoCal, NpoCnd
FROM GE_CalRimt
WHERE MonImt=@MonAnt

INSERT INTO GE_ZItf
(NomTbl, PkReg, NomCol, VlrACol)
SELECT NomTbl, ZK.PkRegNue, NomCol, VlrACol
FROM GE_ZItf ZVR
INNER JOIN (
		SELECT Cia+'|'+Imt+'|'+MonImt+'|'+ SUBSTRING(REPLACE(CONVERT(varchar(20), FchVig, 120),'-','/'),1,10)+'|'+CAST(Sec AS CHAR) PkReg,
			Cia+'|'+Imt+'|'+@MonNue+'|'+ SUBSTRING(REPLACE(CONVERT(varchar(20), FchVig, 120),'-','/'),1,10)+'|'+CAST(Sec AS CHAR) PkRegNue
		FROM GE_CalRimt ) ZK
	ON ZK.PkReg=ZVR.PkReg
WHERE ZVR.NomTbl='GE_CalRimt'



--agregar moneda en especificaciones de caja
--LSpfMon
UPDATE GE_Cja
SET LSpfMon= LSpfMon+'|'+@MonNue+'=' + LTRIM(Cast(Round(Cast(dbo.Pmt_Obt(LSpfMon,@MonAnt) as money)/@FctrCamb,2) as CHAR))
WHERE LSpfMon like '%'+@MonAnt+'%'

--LSpfVacCja
UPDATE GE_Cja
SET LSpfVacCja=LSpfVacCja + '/' + @MonNue+'='+dbo.Pmt_Obt(replace(LSpfVacCja,'/','|'),@MonAnt)
WHERE LSpfVacCja like '%'+@MonAnt+'%'

-- definiciones de documentos
UPDATE GE_DefDoc
SET TipTsa=@TipTsa
WHERE MonDoc=@MonAnt
	AND TipTsa=''
	
--agregar zitf de VigSpfMon si no existe y es la mondoc
INSERT INTO GE_ZItf
(NomTbl, PkReg, NomCol, VlrACol)
SELECT 'GE_DefDoc' NomTbl, Rtrim(Cast(ClsDoc as Char))+'/'+CodDoc PkReg, 
	'LSpfVigMonDoc' NomCol, @FchIniA+'='+@MonNue VlrACol
FROM GE_DefDoc DD
WHERE DD.MonDoc=@MonAnt
AND NOT EXISTS (
	SELECT * 
	FROM GE_Zitf ZLVM
	WHERE NomTbl='GE_DefDoc'
		AND NomCol='LSpfVigMonDoc'
		AND ZLVM.PkReg=Rtrim(Cast(DD.ClsDoc as Char))+'/'+DD.CodDoc
	) 

--actualizar si si existe
UPDATE GE_ZItf
SET VlrACol=ZLVM.VlrAcol+'|'+@FchIniA+'='+@MonNue
FROM GE_Zitf ZLVM
WHERE NomTbl='GE_DefDoc'
	AND NomCol='LSpfVigMonDoc'
	AND VlrACol like '%'+@MonAnt


--Moneda de precios
INSERT INTO GE_ZItf
(NomTbl, PkReg, NomCol,VlrACol)
SELECT 'GE_Prc' NomTbl, Prc.Lprc+'|'+Prc.SucPrc+'|'+ REPLACE(CONVERT(varchar,Prc.StmVig,120),'-','/')+'|'+Prc.Prd+'|'+Prc.UmPrc PkReg, 
	'MonPrc' NomCol, Lprc.MonLprc  VlrACol
FROM GE_Prc Prc
LEFT JOIN GE_Lprc Lprc
	ON Lprc.Lprc=Prc.Lprc
WHERE NOT EXISTS (
	SELECT *
	FROM GE_ZItf z
	WHERE NomTbl='GE_Prc'
		AND NomCol='MonPrc'
		AND z.PkReg=Prc.Lprc+'|'+Prc.SucPrc+'|'+ REPLACE(CONVERT(varchar,Prc.StmVig,120),'-','/')+'|'+Prc.Prd+'|'+Prc.UmPrc
	)
	
	
--seteo del tipo de tasa de la lista
INSERT INTO GE_ZItf
(NomTbl, PkReg, NomCol,VlrACol)
SELECT 'GE_Lprc' NomTbl, Lprc.Lprc PkRef, 'TipTsaBas' NomCol, @TipTsa VlrACol
FROM GE_Lprc Lprc
WHERE MonLprc=@MonAnt
	AND Not EXISTS(
		SELECT * 
		FROM GE_ZItf Z
		WHERE NomTbl='GE_Lprc'
			AND NomCol='TipTsaBas'
			AND PkReg=Lprc.Lprc)
		



